﻿using Percent___Qualification_work.Classes;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;


namespace Percent___Qualification_work.userControls
{
    public partial class addMovie : UserControl
    {
        public List<DataRow> movieData;
        Movie existingMovie;
        Movie newMovie;
        api_scrape_movie scraper = new api_scrape_movie();
        byte[] imageBlob;
        public addMovie()
        {
            InitializeComponent();
            movieGenre.DropDownStyle = ComboBoxStyle.DropDownList;
        }

        private async void findMovieBtn_Click(object sender, EventArgs e)
        {
            if(movieName.Text == "")
            {
                MessageBox.Show("Please enter the name of the movie!");
            }
            else
            {
                string name = movieName.Text;
                existingMovie = DatabaseConnection.Instance.GetMovie(name);

                if (existingMovie != null)
                {
                    // If the wanted movie is in the database:
                    DialogResult result = MessageBox.Show(existingMovie.ToString(), "Confirm movie", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (result == DialogResult.Yes)
                    {
                        // If the movie is not in the user's list:
                        if (!DatabaseConnection.Instance.IsMovieInList(Authentication.ActiveUserID, existingMovie.Id))
                        {
                            backBtn.Visible = true;
                            allInputs.Visible = true;
                            movieName.Enabled = false;
                            movieDirector.Text = existingMovie.Director;
                            movieDirector.Enabled = false;
                            movieGenre.Text = existingMovie.Genre;
                            movieGenre.Enabled = false;
                            movieYear.Value = existingMovie.ReleaseYear;
                            movieYear.Enabled = false;
                        }
                        else
                        {
                            MessageBox.Show("This movie is already in your list!");
                        }
                    }
                }
                else
                {
                    // If the movie isn't in the database:
                    MessageBox.Show("This movie isn't in our database. The system will try to fetch data from the internet. Please wait...");
                    await GetMovieFromAPI(movieName.Text);

                    if (newMovie != null)
                    {
                        DialogResult result = MessageBox.Show(newMovie.ToString(), "Confirm movie", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                        if (result == DialogResult.Yes)
                        {
                            backBtn.Visible = true;
                            allInputs.Visible = true;
                            movieName.Enabled = false;
                            movieDirector.Text = newMovie.Director;
                            movieDirector.Enabled = false;
                            movieGenre.Text = newMovie.Genre;
                            movieGenre.Enabled = false;
                            movieYear.Value = newMovie.ReleaseYear;
                            movieYear.Enabled = false;
                        }
                        else
                        {
                            MessageBox.Show("Please enter the movie data manually or try to search again!");
                            EnableInputs();
                            backBtn.Visible = true;
                            allInputs.Visible = true;
                            openFile.Visible = true;
                            imageName.Visible = true;
                        }
                    }
                    else
                    {
                        MessageBox.Show("Looks like we coulnd get the data for the movie, please enter manually!");
                        EnableInputs();
                        backBtn.Visible = true;
                        allInputs.Visible = true;
                        openFile.Visible = true;
                        imageName.Visible = true;
                    }
                }
            }
            
        }
        private async Task GetMovieFromAPI(string movieName)
        {
            newMovie = await scraper.GetMovie(movieName);
        }

        

        private void coverImageDialog_FileOk(object sender, CancelEventArgs e)
        {
            string fileName = coverImageDialog.FileName;
            string fileExtension = Path.GetExtension(fileName).ToLower();

            // Check if the file is a PNG or JPG/JPEG
            if (fileExtension == ".png" || fileExtension == ".jpg" || fileExtension == ".jpeg")
            {
                // Convert the image file to a byte array
                imageBlob = File.ReadAllBytes(fileName);

                // Display only the file name without the path
                string fileOnlyName = Path.GetFileName(fileName);
                imageName.Text = fileOnlyName;
            }
            else
            {
                MessageBox.Show("Please select a valid image file (.png, .jpg, .jpeg).", "Invalid File Type", MessageBoxButtons.OK, MessageBoxIcon.Error);
                e.Cancel = true; // Cancel the file selection if the file is not valid
            }
        }

        private void openFile_Click(object sender, EventArgs e)
        {
            DialogResult result = coverImageDialog.ShowDialog();
        }


        private void saveMovie_Click(object sender, EventArgs e)
        {
            if (existingMovie != null)
            {
                int score = Convert.ToInt32(userScore.Value);
                DatabaseConnection.Instance.AddMovieToUserList(Authentication.ActiveUserID, existingMovie.Id, score);
                MessageBox.Show("Movie was successfully added to your list!");
                ClearInputs();
                CloseWindow();
                existingMovie = null;
            }
            else
            {
                if (!string.IsNullOrEmpty(movieName.Text) &&
                    !string.IsNullOrEmpty(movieGenre.Text) &&
                    !string.IsNullOrEmpty(movieDirector.Text) &&
                    movieYear.Value != null &&
                    imageBlob != null)
                {
                    newMovie = new Movie(null, movieName.Text, movieGenre.Text, movieDirector.Text, Convert.ToInt32(movieYear.Value), imageBlob);
                    DatabaseConnection.Instance.AddMovieToDB(newMovie);
                    newMovie = DatabaseConnection.Instance.GetMovie(newMovie.Name);
                    DatabaseConnection.Instance.AddMovieToUserList(Authentication.ActiveUserID, newMovie.Id, Convert.ToInt32(userScore.Value));
                    MessageBox.Show("Movie was successfully added to the database and your list!");
                    ClearInputs();
                    CloseWindow();
                    newMovie = null;
                }
                else if (newMovie != null)
                {
                    DatabaseConnection.Instance.AddMovieToDB(newMovie);
                    newMovie = DatabaseConnection.Instance.GetMovie(newMovie.Name);
                    DatabaseConnection.Instance.AddMovieToUserList(Authentication.ActiveUserID, newMovie.Id, Convert.ToInt32(userScore.Value));
                    MessageBox.Show("Movie was successfully added to the database and your list!");
                    ClearInputs();
                    CloseWindow();
                    newMovie = null;
                }
                else
                {
                    MessageBox.Show("Please fill in all the fields! And don't forget to add a cover image!");
                }
            }
        }

        private void backBtn_Click(object sender, EventArgs e)
        {
            ClearInputs();
            CloseWindow();
        }

        private void ClearInputs()
        {
            movieName.Text = "";
            movieDirector.Text = "";
            movieGenre.Text = "";
            movieYear.Value = 1950;
            userScore.Value = 1;
            imageName.Text = "";
        }

        private void CloseWindow()
        {
            allInputs.Visible = false;
            backBtn.Visible = false;
            openFile.Visible = false;
            imageName.Visible = false;
            movieName.Enabled = true;
        }
        public void EnableInputs()
        {
            movieDirector.Enabled = true;
            movieGenre.Enabled = true;
            movieYear.Enabled = true;

        }

    }
}
